IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CLI_CONV_PBM_ENTRADAS]') 
					AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_RC_CLI_CONV_PBM_ENTRADAS]
END
GO
--EXEC P_RC_CLI_CONV_PBM_ENTRADAS 1, '','2020-08-01','2020-08-31',85904   
CREATE PROCEDURE P_RC_CLI_CONV_PBM_ENTRADAS (@CD_EMP		INT,
													@CD_FILIAL	VARCHAR(MAX)='',
													@DT_INI		DATETIME=NULL,
													@DT_FIM		DATETIME=NULL,
													@CD_PROD	INT=NULL)

AS

	
set nocount on	
	CREATE TABLE #TMPFILIAL (cd_emp int, cd_filial INT);
	IF @CD_FILIAL =''
		BEGIN
			INSERT INTO #TMPFILIAL
			SELECT CD_EMP, CD_FILIAL
			FROM PRC_FILIAL
		END
	ELSE
		BEGIN
			INSERT INTO #TMPFILIAL
			SELECT CD_EMP,CD_FILIAL
			FROM PRC_FILIAL
			WHERE 
				CD_EMP = @CD_EMP
				AND CD_FILIAL IN(SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL));
		END


	CREATE TABLE #RsProcEntradaPBM  (CD_EMP    INT,
								 CD_FILIAL INT,
								 CD_NF     INT,
								 PERC_ATENDIDO INT )


	INSERT INTO #RsProcEntradaPBM
    SELECT
            EST_NF_ENT.CD_EMP
        , EST_NF_ENT.CD_FILIAL
        , EST_NF_ENT.CD_NF
        , REPOSICAO_PBM.PERC_ATEND
    FROM
        EST_NF_ENT
        JOIN #TMPFILIAL F ON F.CD_EMP = EST_NF_ENT.CD_EMP
                                AND F.CD_FILIAL = EST_NF_ENT.CD_FILIAL
        INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT D ON D.CD_EMP = EST_NF_ENT.CD_EMP
                                                                AND D.CD_FILIAL = EST_NF_ENT.CD_FILIAL
                                                                AND D.CD_NF = EST_NF_ENT.CD_NF
        INNER JOIN V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM REPOSICAO_PBM ON REPOSICAO_PBM.CD_EMP = D.CD_EMP
                                                                                AND REPOSICAO_PBM.CD_CTR = D.CD_CTR
    WHERE EST_NF_ENT.CD_EMP = @CD_EMP
            AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
            AND REPOSICAO_PBM.PERC_ATEND = 100;


	SELECT
			EST_NF_ENT_IT.CD_EMP,
			EST_NF_ENT_IT.CD_FILIAL,
			EST_NF_ENT_IT.CD_PROD,
			EST_NF_ENT_IT.DS_PROD,
			EST_NF_ENT_IT.DT_ENT,
			V_EST_NF_ENT_CAB.NR_NF,
			DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),V_EST_NF_ENT_CAB.NR_NF) + ' ORIGEM.: ' + CONVERT(VARCHAR(10),V_EST_NF_ENT_CAB.CD_ORIG) + ' CIDADE: ' + DS_CID + ' - ' + UF HISTORICO,
			case when ISNULL(EST_NF_ENT_IT_PBM_GLOSADA.CD_NF,0) > 0 THEN 0 ELSE  EST_NF_ENT_IT.QT_IT END AS QT_IT,
			EST_NF_ENT_IT.VLR_IT AS VLR_IT,
			EST_NF_ENT_IT.CD_NF,
			CONVERT(CHAR(10),COALESCE(V_EST_NF_ENT_CAB.DT_HR_CAD,V_EST_NF_ENT_CAB.DT_ENT),120) + ' ' + CONVERT(CHAR(5),ISNULL(V_EST_NF_ENT_CAB.DT_HR_CAD,''),114) Dt_Hr_Entrada,
			case when ISNULL(EST_NF_ENT_IT_PBM_GLOSADA.CD_NF,0) >0 THEN  1
				ELSE 0 END GLOSADO
		FROM
			V_EST_NF_ENT_CAB INNER JOIN EST_NF_ENT_IT ON
			V_EST_NF_ENT_CAB.CD_EMP = EST_NF_ENT_IT.CD_EMP AND
			V_EST_NF_ENT_CAB.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND
			V_EST_NF_ENT_CAB.CD_NF = EST_NF_ENT_IT.CD_NF 
			INNER JOIN (SELECT
							c.CD_EMP
							,c.CD_PROD
							,1 AS QT_IT
							,PBM.DT_ATIVAR_CONTROLE
						FROM
							EST_PROD_RC_CLI_CONV c
							INNER JOIN RC_CLI_CONV_PBM pbm ON
								C.CD_EMP = pbm.CD_EMP AND
								C.CD_CONV = pbm.CD_CONV
						WHERE
							pbm.FLAG_POSSUI_REPOSICAO_PRODUTOS = 1
						GROUP  BY
							c.CD_EMP
							,c.CD_PROD
							,PBM.DT_ATIVAR_CONTROLE) P ON
			EST_NF_ENT_IT.CD_PROD = P.CD_PROD AND
			EST_NF_ENT_IT.CD_EMP = P.CD_EMP AND
			EST_NF_ENT_IT.DT_ENT >= P.DT_ATIVAR_CONTROLE
			LEFT OUTER JOIN  EST_NF_ENT_IT_PBM_GLOSADA ON
			EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_IT_PBM_GLOSADA.CD_EMP AND
			EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_IT_PBM_GLOSADA.CD_FILIAL AND
			EST_NF_ENT_IT.CD_NF = EST_NF_ENT_IT_PBM_GLOSADA.CD_NF AND
			EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_IT_PBM_GLOSADA.CD_PROD 
			INNER JOIN #TMPFILIAL PR ON
			EST_NF_ENT_IT.CD_EMP = PR.CD_EMP AND
			EST_NF_ENT_IT.CD_FILIAL = PR.CD_FILIAL 
			 inner join #RsProcEntradaPBM RsProcEntradaPBM on RsProcEntradaPBM.CD_EMP    =  V_EST_NF_ENT_CAB.CD_EMP
		 												 and RsProcEntradaPBM.CD_FILIAL =  V_EST_NF_ENT_CAB.CD_FILIAL
		 												 and RsProcEntradaPBM.CD_NF     =  V_EST_NF_ENT_CAB.CD_NF
		WHERE
			EST_NF_ENT_IT.CD_EMP =@CD_EMP 
			AND EST_NF_ENT_IT.DT_ENT BETWEEN @DT_INI AND @DT_FIM 
			AND EST_NF_ENT_IT.CD_PROD = CASE WHEN ISNULL(@CD_PROD,0) >0 THEN @CD_PROD ELSE EST_NF_ENT_IT.CD_PROD  END
		

		 